﻿/*		VERSION:  1.0
	1.0			Initial version as a function that adds a "brightness" property to another movieClip
	
USAGE:
	#include "functions/addBrightness.as"
	addBrightness( my_mc );
	my_mc.brightness = 100;		// white
	
KNOWN BUGS:
	If the movieClip was dragged to the stage and adjusted to have a negative brightness via the property ribbon instead of code,
	then that brightness will be reset to Zero.
*/

function addBrightness( target ){
	if( !target )
		var target = this;
	
	// if "brightness" property is already applied, then abort
	if( target.hasOwnProperty("brightness") )
		return;
	
	// get initial brightness
	var init_red = target.transform.colorTransform.redMultiplier;
	var init_green = target.transform.colorTransform.greenMultiplier;
	var init_blue = target.transform.colorTransform.blueMultiplier;
	//// default
	var init_brightness = 0;		// neutral
	//// pre-populated variable
	if(target.brightness){
		init_brightness = target.brightness;
	}
	//// pre-populated brightness
	else if( init_red === init_green  &&  init_red === init_blue ){
		init_brightness = init_red *100 /255;		// scale from 255 to 100 as the max
	}
	
	function get_brightness(){
		return target.transform.colorTransform.redOffset;
	}
	function set_brightness( newValue ){
		var alphaScale = _alpha /100;
		var br = newValue *255 /100;		// scale from 100 to 255 as the max;
		target.transform.colorTransform = new flash.geom.ColorTransform( 1,1,1,alphaScale, br,br,br,0);
	}// set()
	target.addProperty("brightness", get_brightness, set_brightness);
	target.brightness = init_brightness;
}// addBrightness()